/*genereaza AP cu 192.168.4.1
 * password 12345678
 * led intern  GPIO 2
 * generaza pag web simpla
 * 
 * https://microcontrollerslab.com/esp32-web-server-arduino-led/
*/
#include "WiFi.h"
#define LED1 2
const char* ssid = "ESP32-Soft-AP";
const char* password = "12345678";
WiFiServer server(80);

String html ="<!DOCTYPE html> \
<html> \
<body> \
<center><h1>ESP32 Soft access point</h1></center> \
<form> \
<center><button name=\"LED1\" button style=\"color:green\" value=\"ON\" type=\"submit\">LED1 ON</button> \
<center><button name=\"LED1\" button style=\"color:red\" value=\"OFF\" type=\"submit\">LED1 OFF</button> \
</form> \
</body> \
</html>";

void Connect_WiFi()
{
WiFi.begin(ssid, password);
while(WiFi.status() != WL_CONNECTED)
{
delay(100);
}
}

void setup()
{
Serial.begin(115200);
pinMode(LED1, OUTPUT);
digitalWrite(LED1, LOW);
Serial.print("Setting soft access point mode");
WiFi.softAP(ssid, password);
IPAddress IP = WiFi.softAPIP();
Serial.print("AP IP address: ");
Serial.println(IP);
server.begin();
}


void loop()
{
WiFiClient client=server.available();
if(client)
{
String request = client.readStringUntil('\r');
if(request.indexOf("LED1=ON") != -1)digitalWrite(LED1, HIGH);
if(request.indexOf("LED1=OFF") != -1)digitalWrite(LED1, LOW);
client.print(html);
request="";
}
}
